﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucNoteSelectionPanel.ascx.cs" Inherits="ucNoteSelectionPanel" %>
<script type="text/javascript">
    function fnUCNoteSelUpdate() {
        Ext.getCmp('tfEventNoteTitle').setValue(Ext.getCmp('tfNoteTitle').getValue());
        Ext.getCmp('tfEventNoteLocation').setValue(Ext.getCmp('tfEncounterlocation').getValue());
        Ext.getCmp('tfEvtNoteConsult').setValue(Ext.getCmp('tfEncConsult').getValue());
        Ext.getCmp('tfEvtNoteCosigner').setValue(Ext.getCmp('tfCoSigner').getValue());
    }

    function fnNoteTitleValSearch() {
        if (App.tfNoteTitleSearch.isValid()) {
            App.btnSearchNoteTitle.setDisabled(false);
        } else {
            App.btnSearchNoteTitle.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNewVisitValSearch() {
        if (App.tfClinicSearch.isValid()) {
            App.btnSearchClinic.setDisabled(false);
        } else {
            App.btnSearchClinic.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteConsultValForm() {
        if (App.dfConsultFromDate.isValid() && App.dfConsultToDate.isValid()) {
            App.btnSearchConsults.setDisabled(false);
        } else {
            App.btnSearchConsults.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteCApptValForm() {
        if (App.dfApptFromDate.isValid() && App.dfApptToDate.isValid()) {
            App.btnSearchAppointments.setDisabled(false);
        } else {
            App.btnSearchAppointments.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteVisitValForm() {
        if (App.dfVisitFromDate.isValid() && App.dfVisitToDate.isValid()) {
            App.btnSearchVisits.setDisabled(false);
        } else {
            App.btnSearchVisits.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteAdminValForm() {
        if (App.dfAdmitFromDate.isValid() && App.dfAdmitToDate.isValid()) {
            App.btnSearchAdmissions.setDisabled(false);
        } else {
            App.btnSearchAdmissions.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    //function fnNoteSelectValForm() {
    //    if (App.tfNoteTitleSearch.isValid() && App.tfClinicSearch.isValid() &&
    //        App.dfVisitFromDate.isValid() && App.dfVisitToDate.isValid() &&
    //        App.dfAdmitFromDate.isValid() && App.dfAdmitToDate.isValid() &&
    //        App.dfConsultFromDate.isValid() && App.dfConsultToDate.isValid() &&
    //        App.dfNewVisitDate.isValid() && App.tfNewVisitTime.isValid()) {
    //        App.btnEventNoteOK.setDisabled(false);
    //    }
    //    else {
    //        App.btnEventNoteOK.setDisabled(true);
    //    }
    //}

    function fnHideNoteSelection() {
        App.tfNoteTitleSearch.clear();
        App.tfClinicSearch.clear();
        App.tfCosignerSearch.clear();

        App.dfNewVisitDate.clear();
        App.tfNewVisitTime.clear();

        App.dfNewVisitDate.clearInvalid();
        App.tfNewVisitTime.clearInvalid();
    }

</script>
<ext:Panel 
    ID="wndSelectNote" 
    Title="Select the note title and visit for the TIU note." 
    Layout="AnchorLayout" 
    IDMode="Static" 
    runat="server">
<Listeners>
</Listeners>
<Items>
   
         <ext:Panel 
            Border="false" 
            Layout="FitLayout" 
            runat="server" 
            Padding="0" Flex="1">
        <Items>
        <ext:TabPanel 
            ID="TabPanelNote"   
            Margins="0 0 0 0" 
            AnchorHorizontal="100%" 
            Layout="FitLayout" 
            BorderSpec="2 2 2 2"
            runat="server" AutoDoLayout="true">
            <Items>

            <ext:Panel Border="false" 
                ID="tpNoteTitles" 
                Title="Note Title" 
                runat="server" 
                AutoDataBind="true">
                <Items>

                    <ext:Panel Layout="ColumnLayout" runat="server" Border="false">
                        <Items>
                            <ext:Label  Padding="5" Text="Search" runat="server"></ext:Label>

                            <ext:TextField MinLength="3" MaxLength="50" Padding="3" ID="tfNoteTitleSearch" ReadOnly="false"
                                Width="300" runat="server" Vtype="alphanumXSS">
                                <Listeners>
                                    <Change Fn="fnNoteTitleValSearch" />
                                </Listeners>
                            </ext:TextField>

                            <ext:Button Text="Search Note Titles" Handler="App.direct.UCNOTESELPANEL.SearchNoteTitles();" Padding="5"
                                Icon="Magnifier" ID="btnSearchNoteTitle" runat="server">
                                <Listeners>
                                </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteTitle"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="195"
                        Padding="1" Border="false">
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnNoteTitleSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteTitle" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlTitle" runat="server">
                            <Columns>

                                <ext:Column ID="Column1" runat="server"
                                    DataIndex="NOTE_TITLE_TAG" Text="IEN"
                                    Flex="13" />

                                <ext:Column ID="Column2" runat="server"
                                    DataIndex="NOTE_TITLE_LABEL" Text="Note Title"
                                    Flex="71">
                                    <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column ID="Column3" runat="server"
                                    DataIndex="CONSULT_YN" Text="Consult"
                                    Flex="9" />

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteTitle"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteTitle" runat="Server" IDProperty="NOTE_TITLE_TAG,NOTE_TITLE_LABEL">
                                        <Fields>
                                            <ext:ModelField Name="NOTE_TITLE_TAG" />
                                            <ext:ModelField Name="NOTE_TITLE_LABEL" />
                                            <ext:ModelField Name="IS_CONSULT" />
                                            <ext:ModelField Name="CONSULT_YN" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpConsults"
                runat="server"
                Title="Consult"
                AutoDataBind="true" 
                Border="false" >
                <Items>

                    <ext:Panel Border="false"  ID="pnlConsultDateRange" Layout="ColumnLayout" runat="server">
                        <Items>
                            <ext:Label ID="Label6" Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfConsultFromDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteConsultValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label ID="Label7" Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfConsultToDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteConsultValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Consults" Handler="App.direct.UCNOTESELPANEL.SearchConsults();"
                                Padding="5" Icon="Magnifier" ID="btnSearchConsults" runat="server">
                            <Listeners>

                            </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteConsult"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnConsultSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteConsult" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmNoteConsult" runat="server">
                            <Columns>

                                <ext:DateColumn ID="DateColumn1" runat="server"
                                    DataIndex="CONSULT_DATETIME" Text="Date/Time"
                                    Flex="23"  Format="Y-m-dd HH:i:s" />

                                <ext:Column ID="Column4" runat="server"
                                    DataIndex="CONSULT_TITLE" Text="Title"
                                    Flex="48">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column ID="Column5" runat="server"
                                    DataIndex="CONSULT_STATUS" Text="Status"
                                    Flex="15">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteConsult"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteConsult" runat="Server" IDProperty="CONSULT_ID">
                                        <Fields>
                                            <ext:ModelField Name="CONSULT_ID" />
                                            <ext:ModelField Name="CONSULT_DATETIME" Type="Date" />
                                            <ext:ModelField Name="CONSULT_STATUS" />
                                            <ext:ModelField Name="CONSULT_TITLE" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpClinicAppointments"
                runat="server"
                Title="Clinic Appointments" Visible="false"
                AutoDataBind="true" 
                Border="false" >
                <Items>

                    <ext:Panel ID="pnlApptDateRange" Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>
                            <ext:Label ID="Label8" Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfApptFromDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteCApptValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label ID="Label9" Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfApptToDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteCApptValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Appointments" Handler="App.direct.UCNOTESELPANEL.SearchAppointments();"
                                Padding="5" Icon="Magnifier" ID="btnSearchAppointments" runat="server">
                            <Listeners>

                            </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteAppt"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="222" 
                        Padding="1" Border="false" 
                        >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnAppointmentSelect(  Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteAppt" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlAppt" runat="server">
                            <Columns>

                                <ext:DateColumn ID="DateColumn2" runat="server"
                                    DataIndex="APPT_DATETIME" Text="Date/Time"
                                    Flex="23" Format="Y-m-dd HH:i:s" />

                                <ext:Column ID="colApptClinicLabel" runat="server"
                                    DataIndex="CLINIC_LABEL" Text="Clinic" 
                                    Flex="51">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>
                                
                                <ext:Column ID="colApptCurrentStatus" runat="server"
                                    DataIndex="APPT_CURRENT_STATUS" Text="Current Status"
                                    Flex="25">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteAppt"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteAppt" runat="Server" IDProperty="APPT_ID">
                                        <Fields>
                                            <ext:ModelField Name="APPT_ID" />
                                            <ext:ModelField Name="REGION_ID" />
                                            <ext:ModelField Name="SITE_ID" />
                                            <ext:ModelField Name="DFN" />
                                            <ext:ModelField Name="APPT_DATETIME" Type="Date"  />
                                            <ext:ModelField Name="CLINIC_LABEL" />
                                            <ext:ModelField Name="APPT_CLINIC_ID" />
                                            <ext:ModelField Name="APPT_CURRENT_STATUS" />
                                            <ext:ModelField Name="APPT_PURPOSE" />
                                            <ext:ModelField Name="APPT_TIMESTAMP" />
                                            <ext:ModelField Name="APPT_VISIT_ID" />
                                            <ext:ModelField Name="APPT_TYPE" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpVisits"
                runat="server"
                Title="Visits"
                AutoDataBind="true"  
                Border="false" >
                <Items>

                    <ext:Panel ID="pnlVisitDateRange" Layout="ColumnLayout" runat="server" Border="false">
                        <Items>
                            <ext:Label ID="Label1ucnotesel"  Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfVisitFromDate"
                                runat="server"
                                AllowBlank="false"
                                MaxDate="<%# DateTime.Today %>"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteVisitValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label ID="Label2ucnotesel" Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfVisitToDate"
                                runat="server"
                                AllowBlank="false"
                                MaxDate="<%# DateTime.Today %>"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteVisitValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Visits" Handler="App.direct.UCNOTESELPANEL.SearchVisits();"
                                Padding="5" Icon="Magnifier" ID="btnSearchVisits" runat="server">
                            <Listeners>

                            </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteVisit"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnNoteVisitSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteVisit" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmNoteVisit" runat="server">
                            <Columns>

                                <ext:DateColumn ID="DateColumn3"   runat="server"
                                    DataIndex="VISIT_DATETIME" Text="Date/Time"
                                    Flex="23" Format="Y-m-dd HH:i:s" />

                                <ext:Column ID="Column6"   runat="server"
                                    DataIndex="VISIT_LOCATION_NAME" Text="Title"
                                    Flex="38" />

                                <ext:Column ID="Column7"   runat="server"
                                    DataIndex="VISIT_STATUS" Text="Status"
                                    Flex="18" />

                                <ext:Column ID="Column8"  runat="server"
                                    DataIndex="VISIT_TYPE" Text="Type"
                                    Flex="15" />

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteVisit"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteVisit" runat="Server" IDProperty="VISIT_DATETIME">
                                        <Fields>
                                            <ext:ModelField Name="VISIT_ID" />
                                            <ext:ModelField Name="VISIT_LOCATION_ID" />
                                            <ext:ModelField Name="VISIT_LOCATION_NAME" />
                                            <ext:ModelField Name="VISIT_TIMESTAMP" />
                                            <ext:ModelField Name="VISIT_STATUS" />
                                            <ext:ModelField Name="VISIT_TYPE" />
                                            <ext:ModelField Name="VISIT_DATETIME" Type="Date" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpHospitalAdmissions"
                runat="server"
                Title="Hospital Admissions"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel ID="pnlAdmitDateRange" Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>

                            <ext:Label ID="lblAdmitFrom" Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfAdmitFromDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteAdminValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label ID="lblAdmitTo" Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfAdmitToDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteAdminValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Admissions" Handler="App.direct.UCNOTESELPANEL.SearchAdmissions();" Padding="5" Icon="Magnifier"
                                ID="btnSearchAdmissions" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>


                    <ext:GridPanel
                        ID="gpNoteAdmit"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" 
                        >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnAdmissionSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteAdmit" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlAdmit" runat="server">
                            <Columns>

                                <ext:DateColumn ID="DateColumn4" runat="server"
                                    DataIndex="ADMIT_DATETIME" Text="Date/Time"
                                    Flex="23" Format="Y-m-dd HH:i:s"  />

                                <ext:Column ID="Column9" runat="server"
                                    DataIndex="ADMIT_LOCATION_NAME" Text="Location"
                                    Flex="48">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column ID="Column10" runat="server"
                                    DataIndex="ADMIT_TYPE" Text="Type"
                                    Flex="23">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteAdmit"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteAdmit" runat="Server" IDProperty="ADMIT_DATETIME">
                                        <Fields>
                                            <ext:ModelField Name="REGION_ID" />
                                            <ext:ModelField Name="SITE_ID" />
                                            <ext:ModelField Name="DFN" />
                                            <ext:ModelField Name="ADMIT_LOCATION_ID" />
                                            <ext:ModelField Name="ADMIT_DATETIME" Type="Date" />
                                            <ext:ModelField Name="ADMIT_LOCATION_NAME" />
                                            <ext:ModelField Name="ADMIT_TYPE" />
                                            <ext:ModelField Name="ADMIT_TIMESTAMP" />
                                            <ext:ModelField Name="ADMIT_DISCHARGE_TIMESTAMP" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>
                </Items>
            </ext:Panel>

            <ext:Panel ID="tpNewVisit"
                runat="server"
                Title="New Visit"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel ID="Panel6" Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>
                            <ext:Label ID="Label10" Text="Date/Time of Visit" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfNewVisitDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="4"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                            <Listeners>
                                <Change Handler="if(App.dfNewVisitDate.isValid()) {App.direct.UCNOTESELPANEL.OnDateChange(Ext.encode(#{gpNoteClinic}.getRowsValues({selectedOnly : true})) );}" />
                            </Listeners>
                            </ext:DateField>
                            <ext:TimeField ID="tfNewVisitTime" runat="server"
                                Padding="5" Width="100"
                                MinTime="0:00" 
                                MaxTime="23:59" Format="HH:mm" 
                                Increment="15"
                                Vtype="time2">
                            <Listeners>
                                <Change Handler="if(App.tfNewVisitTime.isValid()) {App.direct.UCNOTESELPANEL.OnTimeChange(Ext.encode(#{gpNoteClinic}.getRowsValues({selectedOnly : true})) );}" />
                            </Listeners>
                            </ext:TimeField>

                            <ext:Checkbox LabelAlign="Right" ID="chkHistoricalNewVisit" Padding="2" runat="server">
                            <Listeners>
                                <Change Handler="App.direct.UCNOTESELPANEL.OnHistorical(this.checked, Ext.encode(#{gpNoteClinic}.getRowsValues({selectedOnly : true})) );" />
                            </Listeners>
                            </ext:Checkbox>
                            <ext:Label ID="Label11" Text="Historical" runat="server" Padding="5"></ext:Label>

                            <ext:Label ID="Label12" Padding="5" Text="" runat="server"></ext:Label>

                            <ext:Label ID="Label13" Padding="5" Text="Search" runat="server"></ext:Label>

                            <ext:TextField AutoDataBind="true" MinLength="3" MaxLength="50"
                                Padding="3" ID="tfClinicSearch" ReadOnly="false" Width="150" runat="server" Vtype="alphanumXSS">
                                <Listeners>
                                    <Change Fn="fnNewVisitValSearch" />
                                </Listeners>
                            </ext:TextField>

                            <ext:Button Text="Search Clinics" Handler="App.direct.UCNOTESELPANEL.SearchClinics();" Padding="5" 
                                Icon="Magnifier" ID="btnSearchClinic" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>


                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteClinic"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" 
                        >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnClinicSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteClinic" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlClinic" runat="server">
                            <Columns>

                                <ext:Column ID="Column11" runat="server"
                                    DataIndex="CLINIC_LABEL" Text="Clinic"
                                    Flex="97">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteClinic"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteClinic" runat="Server" IDProperty="CLINIC_ID">
                                        <Fields>
                                            <ext:ModelField Name="REGION_ID" />
                                            <ext:ModelField Name="SITE_ID" />
                                            <ext:ModelField Name="CLINIC_ID" />
                                            <ext:ModelField Name="CLINIC_LABEL" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>
                    
                </Items>
            </ext:Panel>

            <ext:Panel ID="tpCoSigner"
                runat="server"
                Title="Cosigner"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel ID="Panel7" Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>
                            <ext:Label ID="Label14" Padding="5" Text="Search" runat="server"></ext:Label>

                            <ext:TextField MinLength="3" MaxLength="50" Padding="3" ID="tfCosignerSearch" ReadOnly="false"
                                Width="300" runat="server">
                            </ext:TextField>

                            <ext:Button Text="Search Cosigners" Handler="App.direct.UCNOTESELPANEL.SearchCosigner();"
                                Padding="5" Icon="Magnifier" ID="btnSearchCosigner" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteCosigner"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESELPANEL.OnCosignerSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteCosigner" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmNoteCosigner" runat="server">
                            <Columns>

                                <ext:Column ID="Column12" runat="server"
                                    DataIndex="NAME" Text="Name"
                                    Flex="63">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column ID="Column13" runat="server"
                                    DataIndex="TITLE" Text="Title"
                                    Flex="33">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteCosigner"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteCosigner" runat="Server" IDProperty="FX_USER_ID">
                                        <Fields>
                                            <ext:ModelField Name="NAME" />
                                            <ext:ModelField Name="TITLE" />
                                            <ext:ModelField Name="PROVIDER_ID" />
                                            <ext:ModelField Name="FX_USER_ID" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>
                    
                </Items>
            </ext:Panel>
            
        </Items>
    </ext:TabPanel>
        </Items>
        </ext:Panel>
    
    <ext:Panel ID="pnlQENoteTitle" Title="Selected note title and visit for the TIU note." 
        Border="false" Layout="FitLayout" runat="server" 
        Padding="0" Flex="1">
        <Items>
            <ext:TextField AutoDataBind="true" FieldLabel="Note Title" LabelWidth="120"
                Padding="3" ID="tfNoteTitle" Flex="1" ReadOnly="true" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>

    <ext:Panel ID="pnlQEEncLocation" Border="false" Layout="FitLayout" runat="server" 
        Padding="0" Flex="1">
        <Items>
            <ext:TextField AutoDataBind="true" FieldLabel="Encounter Location" LabelWidth="120"
                Padding="3" ID="tfEncounterlocation" ReadOnly="true" Width="825" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>

    <ext:Panel ID="pnlQEConsult" Border="false" Layout="FitLayout" runat="server" 
        Padding="0" Flex="1">
        <Items>
            <ext:TextField AutoDataBind="true" FieldLabel="Consult" LabelWidth="120"
                Padding="3" ID="tfEncConsult" ReadOnly="true" Width="825" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>

    <ext:Panel ID="pnlQECosigner" Border="false" Layout="FitLayout" runat="server" 
        Padding="0" Flex="1">
        <Items>
            <ext:TextField AutoDataBind="true" FieldLabel="Cosigner" LabelWidth="120"
                Padding="3" ID="tfCoSigner" ReadOnly="true" Width="825" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>
</Items>
</ext:Panel>